/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import dev.toma.gunsrpg.client.screen.widgets.ContainerWidget;
import dev.toma.gunsrpg.client.screen.widgets.IClickResponder;
import dev.toma.gunsrpg.util.math.IVec2i;
import dev.toma.gunsrpg.util.math.Vec2i;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;

public class PannableWidget
extends ContainerWidget {
    private final IContentManager manager;
    private final Map<Widget, IVec2i> initialPositions = new IdentityHashMap<Widget, IVec2i>();
    private int posX;
    private int posY;
    private int boundX;
    private int boundY;
    private IClickResponder<?> responder;

    public PannableWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.manager = this::addWidget;
        this.setEmptyClickResponder(obj -> {});
    }

    public void fill(IContentFillHandler fillHandler) {
        this.fill(fillHandler, true);
    }

    public void fill(IContentFillHandler fillHandler, boolean shouldClear) {
        if (shouldClear) {
            this.clear();
        }
        this.posX = 0;
        this.posY = 0;
        fillHandler.fillElements(this.manager, this.field_230690_l_, this.field_230691_m_);
        this.moveToInitialPositions();
        this.saveInitialPositions();
        this.updateChildren();
        this.computePannableBounds();
    }

    public <T> void setEmptyClickResponder(IClickResponder<T> clickResponder) {
        this.responder = clickResponder;
    }

    public void updateSize(int width, int height) {
        this.field_230688_j_ = width;
        this.field_230689_k_ = height;
        this.childrenAsStream().forEach(this::updateVisibility);
        this.computePannableBounds();
    }

    @Override
    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        boolean clicked = super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
        if (!clicked && this.func_231047_b_(p_231044_1_, p_231044_3_)) {
            this.responder.onElementClicked(null);
            return true;
        }
        return clicked;
    }

    @Override
    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.func_230987_a_(button)) {
            this.func_230983_a_(mouseX, mouseY, dragX, dragY);
            return false;
        }
        return false;
    }

    protected void func_230983_a_(double mouseX, double mouseY, double moveX, double moveY) {
        this.posX += this.moveValue(moveX);
        this.posY += this.moveValue(moveY);
        this.posX = MathHelper.func_76125_a((int)this.posX, (int)Math.min(-this.boundX, 0), (int)0);
        this.posY = MathHelper.func_76125_a((int)this.posY, (int)Math.min(-this.boundY, 0), (int)0);
        this.updateChildren();
    }

    private int moveValue(double value) {
        boolean negative = value < 0.0;
        int ceil = (int)Math.ceil(Math.abs(value));
        return negative ? -ceil : ceil;
    }

    @Override
    public void clear() {
        super.clear();
        this.initialPositions.clear();
    }

    private void updateChildren() {
        this.childrenAsStream().forEach(this::updateChildWidget);
    }

    private void updateChildWidget(Widget widget) {
        IVec2i initialPosition = this.initialPositions.computeIfAbsent(widget, obj -> new Vec2i(obj.field_230690_l_, obj.field_230691_m_));
        widget.field_230690_l_ = initialPosition.x() + this.posX;
        widget.field_230691_m_ = initialPosition.y() + this.posY;
        this.updateVisibility(widget);
    }

    private void moveToInitialPositions() {
        this.childrenAsStream().forEach(this::loadInitialPosition);
    }

    private void saveInitialPositions() {
        this.childrenAsStream().forEach(widget -> this.initialPositions.put((Widget)widget, new Vec2i(widget.field_230690_l_, widget.field_230691_m_)));
    }

    private void loadInitialPosition(Widget widget) {
        IVec2i oldPos = this.initialPositions.computeIfAbsent(widget, obj -> new Vec2i(obj.field_230690_l_, obj.field_230691_m_));
        widget.field_230690_l_ = oldPos.x();
        widget.field_230691_m_ = oldPos.y();
    }

    private void updateVisibility(Widget widget) {
    }

    private boolean checkInViewport(int x, int y) {
        return x >= this.field_230690_l_ && x <= this.field_230690_l_ + this.field_230688_j_ && y >= this.field_230691_m_ && y <= this.field_230691_m_ + this.field_230689_k_;
    }

    private void computePannableBounds() {
        this.boundX = this.initialPositions.values().stream().mapToInt(IVec2i::x).max().orElse(0) - this.field_230688_j_ / 2;
        this.boundY = this.initialPositions.values().stream().mapToInt(IVec2i::y).max().orElse(0) - this.field_230689_k_ / 2;
    }

    @FunctionalInterface
    public static interface IContentManager {
        public <W extends Widget> W add(W var1);
    }

    @FunctionalInterface
    public static interface IContentFillHandler {
        public void fillElements(IContentManager var1, int var2, int var3);
    }
}

